/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Storage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BundleInstanceRequest
extends EC2Request
implements ToCopyableBuilder<Builder, BundleInstanceRequest> {
    private final String instanceId;
    private final Storage storage;

    private BundleInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.storage = builder.storage;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Storage storage() {
        return this.storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInstanceRequest)) {
            return false;
        }
        BundleInstanceRequest other = (BundleInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.storage(), other.storage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.storage() != null) {
            sb.append("Storage: ").append(this.storage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Storage": {
                return Optional.of(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String instanceId;
        private Storage storage;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleInstanceRequest model) {
            this.instanceId(model.instanceId);
            this.storage(model.storage);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Storage.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(Storage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BundleInstanceRequest build() {
            return new BundleInstanceRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, BundleInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder storage(Storage var1);

        default public Builder storage(Consumer<Storage.Builder> storage) {
            return this.storage((Storage)((Storage.Builder)Storage.builder().apply(storage)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

