/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssignPrivateIpAddressesRequest
extends EC2Request
implements ToCopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
    private final Boolean allowReassignment;
    private final String networkInterfaceId;
    private final List<String> privateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;

    private AssignPrivateIpAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.allowReassignment = builder.allowReassignment;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
    }

    public Boolean allowReassignment() {
        return this.allowReassignment;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowReassignment());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest)((Object)obj);
        return Objects.equals(this.allowReassignment(), other.allowReassignment()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.allowReassignment() != null) {
            sb.append("AllowReassignment: ").append(this.allowReassignment()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.privateIpAddresses()).append(",");
        }
        if (this.secondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: ").append(this.secondaryPrivateIpAddressCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowReassignment": {
                return Optional.of(clazz.cast(this.allowReassignment()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddresses": {
                return Optional.of(clazz.cast(this.privateIpAddresses()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.of(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private Boolean allowReassignment;
        private String networkInterfaceId;
        private List<String> privateIpAddresses;
        private Integer secondaryPrivateIpAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesRequest model) {
            this.allowReassignment(model.allowReassignment);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddresses(model.privateIpAddresses);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
        }

        public final Boolean getAllowReassignment() {
            return this.allowReassignment;
        }

        @Override
        public final Builder allowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
            return this;
        }

        public final void setAllowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getPrivateIpAddresses() {
            return this.privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssignPrivateIpAddressesRequest build() {
            return new AssignPrivateIpAddressesRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
        public Builder allowReassignment(Boolean var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

