/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification;
import software.amazon.awssdk.services.ec2.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.IamInstanceProfileSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceNetworkInterfaceSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.SpotFleetMonitoringUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.SpotPlacementUnmarshaller;

public class SpotFleetLaunchSpecificationUnmarshaller
implements Unmarshaller<SpotFleetLaunchSpecification, StaxUnmarshallerContext> {
    private static final SpotFleetLaunchSpecificationUnmarshaller INSTANCE = new SpotFleetLaunchSpecificationUnmarshaller();

    public SpotFleetLaunchSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        SpotFleetLaunchSpecification.Builder spotFleetLaunchSpecification;
        block23: {
            spotFleetLaunchSpecification = SpotFleetLaunchSpecification.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<GroupIdentifier> securityGroups = null;
            ArrayList<BlockDeviceMapping> blockDeviceMappings = null;
            ArrayList<InstanceNetworkInterfaceSpecification> networkInterfaces = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    spotFleetLaunchSpecification.securityGroups(securityGroups);
                    spotFleetLaunchSpecification.blockDeviceMappings(blockDeviceMappings);
                    spotFleetLaunchSpecification.networkInterfaces(networkInterfaces);
                    break block23;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("groupSet", targetDepth)) {
                        securityGroups = new ArrayList<GroupIdentifier>();
                        continue;
                    }
                    if (context.testExpression("groupSet/item", targetDepth)) {
                        securityGroups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("addressingType", targetDepth)) {
                        spotFleetLaunchSpecification.addressingType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping", targetDepth)) {
                        blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                        blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ebsOptimized", targetDepth)) {
                        spotFleetLaunchSpecification.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("iamInstanceProfile", targetDepth)) {
                        spotFleetLaunchSpecification.iamInstanceProfile(IamInstanceProfileSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageId", targetDepth)) {
                        spotFleetLaunchSpecification.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceType", targetDepth)) {
                        spotFleetLaunchSpecification.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("kernelId", targetDepth)) {
                        spotFleetLaunchSpecification.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("keyName", targetDepth)) {
                        spotFleetLaunchSpecification.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("monitoring", targetDepth)) {
                        spotFleetLaunchSpecification.monitoring(SpotFleetMonitoringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("networkInterfaceSet", targetDepth)) {
                        networkInterfaces = new ArrayList<InstanceNetworkInterfaceSpecification>();
                        continue;
                    }
                    if (context.testExpression("networkInterfaceSet/item", targetDepth)) {
                        networkInterfaces.add(InstanceNetworkInterfaceSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("placement", targetDepth)) {
                        spotFleetLaunchSpecification.placement(SpotPlacementUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ramdiskId", targetDepth)) {
                        spotFleetLaunchSpecification.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("spotPrice", targetDepth)) {
                        spotFleetLaunchSpecification.spotPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("subnetId", targetDepth)) {
                        spotFleetLaunchSpecification.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("userData", targetDepth)) {
                        spotFleetLaunchSpecification.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("weightedCapacity", targetDepth)) continue;
                    spotFleetLaunchSpecification.weightedCapacity(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            spotFleetLaunchSpecification.securityGroups(securityGroups);
            spotFleetLaunchSpecification.blockDeviceMappings(blockDeviceMappings);
            spotFleetLaunchSpecification.networkInterfaces(networkInterfaces);
        }
        return (SpotFleetLaunchSpecification)spotFleetLaunchSpecification.build();
    }

    public static SpotFleetLaunchSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

