/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InstanceCount;
import software.amazon.awssdk.services.ec2.model.PriceSchedule;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesListing;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.InstanceCountUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.PriceScheduleUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class ReservedInstancesListingUnmarshaller
implements Unmarshaller<ReservedInstancesListing, StaxUnmarshallerContext> {
    private static final ReservedInstancesListingUnmarshaller INSTANCE = new ReservedInstancesListingUnmarshaller();

    public ReservedInstancesListing unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedInstancesListing.Builder reservedInstancesListing;
        block16: {
            reservedInstancesListing = ReservedInstancesListing.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<InstanceCount> instanceCounts = null;
            ArrayList<PriceSchedule> priceSchedules = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    reservedInstancesListing.instanceCounts(instanceCounts);
                    reservedInstancesListing.priceSchedules(priceSchedules);
                    reservedInstancesListing.tags(tags);
                    break block16;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("clientToken", targetDepth)) {
                        reservedInstancesListing.clientToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("createDate", targetDepth)) {
                        reservedInstancesListing.createDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceCounts", targetDepth)) {
                        instanceCounts = new ArrayList<InstanceCount>();
                        continue;
                    }
                    if (context.testExpression("instanceCounts/item", targetDepth)) {
                        instanceCounts.add(InstanceCountUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("priceSchedules", targetDepth)) {
                        priceSchedules = new ArrayList<PriceSchedule>();
                        continue;
                    }
                    if (context.testExpression("priceSchedules/item", targetDepth)) {
                        priceSchedules.add(PriceScheduleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("reservedInstancesId", targetDepth)) {
                        reservedInstancesListing.reservedInstancesId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("reservedInstancesListingId", targetDepth)) {
                        reservedInstancesListing.reservedInstancesListingId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("status", targetDepth)) {
                        reservedInstancesListing.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("statusMessage", targetDepth)) {
                        reservedInstancesListing.statusMessage(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("updateDate", targetDepth)) continue;
                    reservedInstancesListing.updateDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            reservedInstancesListing.instanceCounts(instanceCounts);
            reservedInstancesListing.priceSchedules(priceSchedules);
            reservedInstancesListing.tags(tags);
        }
        return (ReservedInstancesListing)reservedInstancesListing.build();
    }

    public static ReservedInstancesListingUnmarshaller getInstance() {
        return INSTANCE;
    }
}

