/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice;

public class PurchaseReservedInstancesOfferingRequestMarshaller
implements Marshaller<Request<PurchaseReservedInstancesOfferingRequest>, PurchaseReservedInstancesOfferingRequest> {
    public Request<PurchaseReservedInstancesOfferingRequest> marshall(PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) {
        ReservedInstanceLimitPrice limitPrice;
        if (purchaseReservedInstancesOfferingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purchaseReservedInstancesOfferingRequest, "EC2Client");
        request.addParameter("Action", "PurchaseReservedInstancesOffering");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseReservedInstancesOfferingRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)purchaseReservedInstancesOfferingRequest.instanceCount()));
        }
        if (purchaseReservedInstancesOfferingRequest.reservedInstancesOfferingId() != null) {
            request.addParameter("ReservedInstancesOfferingId", StringUtils.fromString((String)purchaseReservedInstancesOfferingRequest.reservedInstancesOfferingId()));
        }
        if ((limitPrice = purchaseReservedInstancesOfferingRequest.limitPrice()) != null) {
            if (limitPrice.amount() != null) {
                request.addParameter("LimitPrice.Amount", StringUtils.fromDouble((Double)limitPrice.amount()));
            }
            if (limitPrice.currencyCodeString() != null) {
                request.addParameter("LimitPrice.CurrencyCode", StringUtils.fromString((String)limitPrice.currencyCodeString()));
            }
        }
        return request;
    }
}

