/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.net.URI;
import software.amazon.awssdk.core.AmazonClientException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.auth.Aws4Signer;
import software.amazon.awssdk.core.http.SdkHttpFullRequestAdapter;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.regions.Region;
import software.amazon.awssdk.core.util.AwsHostNameUtils;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;

public class GeneratePreSignUrlInterceptor
implements ExecutionInterceptor {
    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (originalRequest instanceof CopySnapshotRequest) {
            CopySnapshotRequest originalCopySnapshotRequest = (CopySnapshotRequest)originalRequest;
            if (originalCopySnapshotRequest.presignedUrl() != null) {
                return request;
            }
            String serviceName = "ec2";
            String sourceRegion = originalCopySnapshotRequest.sourceRegion();
            String sourceSnapshotId = originalCopySnapshotRequest.sourceSnapshotId();
            String destinationRegion = originalCopySnapshotRequest.destinationRegion() != null ? originalCopySnapshotRequest.destinationRegion() : AwsHostNameUtils.parseRegionName((String)request.host(), (String)serviceName);
            URI endPointSource = this.createEndpoint(sourceRegion, serviceName);
            SdkHttpFullRequest requestForPresigning = (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)this.generateRequestForPresigning(sourceSnapshotId, sourceRegion, destinationRegion).toBuilder()).protocol(endPointSource.getScheme()).host(endPointSource.getHost()).port(Integer.valueOf(endPointSource.getPort())).method(SdkHttpMethod.GET).build();
            Aws4Signer signer = new Aws4Signer();
            signer.setServiceName(serviceName);
            InterceptorContext newExecutionContext = InterceptorContext.builder().request(originalRequest).httpRequest(requestForPresigning).build();
            SdkHttpFullRequest presignedRequest = signer.presign((Context.BeforeTransmission)newExecutionContext, executionAttributes, null);
            return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).rawQueryParameter("DestinationRegion", destinationRegion).rawQueryParameter("PresignedUrl", presignedRequest.getUri().toString()).build();
        }
        return request;
    }

    private SdkHttpFullRequest generateRequestForPresigning(String sourceSnapshotId, String sourceRegion, String destinationRegion) {
        CopySnapshotRequest copySnapshotRequest = (CopySnapshotRequest)((Object)CopySnapshotRequest.builder().sourceSnapshotId(sourceSnapshotId).sourceRegion(sourceRegion).destinationRegion(destinationRegion).build());
        return SdkHttpFullRequestAdapter.toHttpFullRequest(new CopySnapshotRequestMarshaller().marshall(copySnapshotRequest));
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw new AmazonClientException("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.");
        }
        return EC2Client.serviceMetadata().endpointFor(region);
    }
}

