/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest;

public class DescribeSecurityGroupReferencesRequestMarshaller
implements Marshaller<Request<DescribeSecurityGroupReferencesRequest>, DescribeSecurityGroupReferencesRequest> {
    public Request<DescribeSecurityGroupReferencesRequest> marshall(DescribeSecurityGroupReferencesRequest describeSecurityGroupReferencesRequest) {
        if (describeSecurityGroupReferencesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSecurityGroupReferencesRequest, "EC2Client");
        request.addParameter("Action", "DescribeSecurityGroupReferences");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeSecurityGroupReferencesRequestGroupIdList = describeSecurityGroupReferencesRequest.groupId();
        if (describeSecurityGroupReferencesRequestGroupIdList != null) {
            int groupIdListIndex = 1;
            for (String describeSecurityGroupReferencesRequestGroupIdListValue : describeSecurityGroupReferencesRequestGroupIdList) {
                if (describeSecurityGroupReferencesRequestGroupIdListValue != null) {
                    request.addParameter("GroupId." + groupIdListIndex, StringUtils.fromString((String)describeSecurityGroupReferencesRequestGroupIdListValue));
                }
                ++groupIdListIndex;
            }
        }
        return request;
    }
}

