/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeReservedInstancesModificationsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesModificationsRequest>, DescribeReservedInstancesModificationsRequest> {
    public Request<DescribeReservedInstancesModificationsRequest> marshall(DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest) {
        List<String> describeReservedInstancesModificationsRequestReservedInstancesModificationIdsList;
        if (describeReservedInstancesModificationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedInstancesModificationsRequest, "EC2Client");
        request.addParameter("Action", "DescribeReservedInstancesModifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeReservedInstancesModificationsRequestFiltersList = describeReservedInstancesModificationsRequest.filters();
        if (describeReservedInstancesModificationsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesModificationsRequestFiltersListValue : describeReservedInstancesModificationsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeReservedInstancesModificationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeReservedInstancesModificationsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeReservedInstancesModificationsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeReservedInstancesModificationsRequestReservedInstancesModificationIdsList = describeReservedInstancesModificationsRequest.reservedInstancesModificationIds()) != null) {
            int reservedInstancesModificationIdsListIndex = 1;
            for (String describeReservedInstancesModificationsRequestReservedInstancesModificationIdsListValue : describeReservedInstancesModificationsRequestReservedInstancesModificationIdsList) {
                if (describeReservedInstancesModificationsRequestReservedInstancesModificationIdsListValue != null) {
                    request.addParameter("ReservedInstancesModificationId." + reservedInstancesModificationIdsListIndex, StringUtils.fromString((String)describeReservedInstancesModificationsRequestReservedInstancesModificationIdsListValue));
                }
                ++reservedInstancesModificationIdsListIndex;
            }
        }
        if (describeReservedInstancesModificationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeReservedInstancesModificationsRequest.nextToken()));
        }
        return request;
    }
}

