/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeImportSnapshotTasksRequestMarshaller
implements Marshaller<Request<DescribeImportSnapshotTasksRequest>, DescribeImportSnapshotTasksRequest> {
    public Request<DescribeImportSnapshotTasksRequest> marshall(DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        List<String> describeImportSnapshotTasksRequestImportTaskIdsList;
        if (describeImportSnapshotTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeImportSnapshotTasksRequest, "EC2Client");
        request.addParameter("Action", "DescribeImportSnapshotTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeImportSnapshotTasksRequestFiltersList = describeImportSnapshotTasksRequest.filters();
        if (describeImportSnapshotTasksRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeImportSnapshotTasksRequestFiltersListValue : describeImportSnapshotTasksRequestFiltersList) {
                List<String> filterValuesList;
                if (describeImportSnapshotTasksRequestFiltersListValue.name() != null) {
                    request.addParameter("Filters." + filtersListIndex + ".Name", StringUtils.fromString((String)describeImportSnapshotTasksRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeImportSnapshotTasksRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filters." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeImportSnapshotTasksRequestImportTaskIdsList = describeImportSnapshotTasksRequest.importTaskIds()) != null) {
            int importTaskIdsListIndex = 1;
            for (String describeImportSnapshotTasksRequestImportTaskIdsListValue : describeImportSnapshotTasksRequestImportTaskIdsList) {
                if (describeImportSnapshotTasksRequestImportTaskIdsListValue != null) {
                    request.addParameter("ImportTaskId." + importTaskIdsListIndex, StringUtils.fromString((String)describeImportSnapshotTasksRequestImportTaskIdsListValue));
                }
                ++importTaskIdsListIndex;
            }
        }
        if (describeImportSnapshotTasksRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeImportSnapshotTasksRequest.maxResults()));
        }
        if (describeImportSnapshotTasksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeImportSnapshotTasksRequest.nextToken()));
        }
        return request;
    }
}

