/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeHostReservationOfferingsRequestMarshaller
implements Marshaller<Request<DescribeHostReservationOfferingsRequest>, DescribeHostReservationOfferingsRequest> {
    public Request<DescribeHostReservationOfferingsRequest> marshall(DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest) {
        if (describeHostReservationOfferingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHostReservationOfferingsRequest, "EC2Client");
        request.addParameter("Action", "DescribeHostReservationOfferings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeHostReservationOfferingsRequestFilterList = describeHostReservationOfferingsRequest.filter();
        if (describeHostReservationOfferingsRequestFilterList != null) {
            int filterListIndex = 1;
            for (Filter describeHostReservationOfferingsRequestFilterListValue : describeHostReservationOfferingsRequestFilterList) {
                List<String> filterValuesList;
                if (describeHostReservationOfferingsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeHostReservationOfferingsRequestFilterListValue.name()));
                }
                if ((filterValuesList = describeHostReservationOfferingsRequestFilterListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeHostReservationOfferingsRequest.maxDuration() != null) {
            request.addParameter("MaxDuration", StringUtils.fromInteger((Integer)describeHostReservationOfferingsRequest.maxDuration()));
        }
        if (describeHostReservationOfferingsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeHostReservationOfferingsRequest.maxResults()));
        }
        if (describeHostReservationOfferingsRequest.minDuration() != null) {
            request.addParameter("MinDuration", StringUtils.fromInteger((Integer)describeHostReservationOfferingsRequest.minDuration()));
        }
        if (describeHostReservationOfferingsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeHostReservationOfferingsRequest.nextToken()));
        }
        if (describeHostReservationOfferingsRequest.offeringId() != null) {
            request.addParameter("OfferingId", StringUtils.fromString((String)describeHostReservationOfferingsRequest.offeringId()));
        }
        return request;
    }
}

