/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DeleteVpcRequest;

public class DeleteVpcRequestMarshaller
implements Marshaller<Request<DeleteVpcRequest>, DeleteVpcRequest> {
    public Request<DeleteVpcRequest> marshall(DeleteVpcRequest deleteVpcRequest) {
        if (deleteVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteVpcRequest, "EC2Client");
        request.addParameter("Action", "DeleteVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteVpcRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)deleteVpcRequest.vpcId()));
        }
        return request;
    }
}

