/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest;

public class CancelExportTaskRequestMarshaller
implements Marshaller<Request<CancelExportTaskRequest>, CancelExportTaskRequest> {
    public Request<CancelExportTaskRequest> marshall(CancelExportTaskRequest cancelExportTaskRequest) {
        if (cancelExportTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cancelExportTaskRequest, "EC2Client");
        request.addParameter("Action", "CancelExportTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelExportTaskRequest.exportTaskId() != null) {
            request.addParameter("ExportTaskId", StringUtils.fromString((String)cancelExportTaskRequest.exportTaskId()));
        }
        return request;
    }
}

