/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrBlock;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrBlockSetCopier;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionOptionsDescription;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcPeeringConnectionVpcInfo
implements ToCopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
    private final String cidrBlock;
    private final List<Ipv6CidrBlock> ipv6CidrBlockSet;
    private final String ownerId;
    private final VpcPeeringConnectionOptionsDescription peeringOptions;
    private final String vpcId;

    private VpcPeeringConnectionVpcInfo(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlockSet = builder.ipv6CidrBlockSet;
        this.ownerId = builder.ownerId;
        this.peeringOptions = builder.peeringOptions;
        this.vpcId = builder.vpcId;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public List<Ipv6CidrBlock> ipv6CidrBlockSet() {
        return this.ipv6CidrBlockSet;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public VpcPeeringConnectionOptionsDescription peeringOptions() {
        return this.peeringOptions;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cidrBlock() == null ? 0 : this.cidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.ipv6CidrBlockSet() == null ? 0 : this.ipv6CidrBlockSet().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.peeringOptions() == null ? 0 : this.peeringOptions().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionVpcInfo)) {
            return false;
        }
        VpcPeeringConnectionVpcInfo other = (VpcPeeringConnectionVpcInfo)obj;
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.ipv6CidrBlockSet() == null ^ this.ipv6CidrBlockSet() == null) {
            return false;
        }
        if (other.ipv6CidrBlockSet() != null && !other.ipv6CidrBlockSet().equals(this.ipv6CidrBlockSet())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.peeringOptions() == null ^ this.peeringOptions() == null) {
            return false;
        }
        if (other.peeringOptions() != null && !other.peeringOptions().equals(this.peeringOptions())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.cidrBlock()).append(",");
        }
        if (this.ipv6CidrBlockSet() != null) {
            sb.append("Ipv6CidrBlockSet: ").append(this.ipv6CidrBlockSet()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.peeringOptions() != null) {
            sb.append("PeeringOptions: ").append(this.peeringOptions()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.of(clazz.cast(this.cidrBlock()));
            }
            case "Ipv6CidrBlockSet": {
                return Optional.of(clazz.cast(this.ipv6CidrBlockSet()));
            }
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "PeeringOptions": {
                return Optional.of(clazz.cast(this.peeringOptions()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private List<Ipv6CidrBlock> ipv6CidrBlockSet;
        private String ownerId;
        private VpcPeeringConnectionOptionsDescription peeringOptions;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionVpcInfo model) {
            this.cidrBlock(model.cidrBlock);
            this.ipv6CidrBlockSet(model.ipv6CidrBlockSet);
            this.ownerId(model.ownerId);
            this.peeringOptions(model.peeringOptions);
            this.vpcId(model.vpcId);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Collection<Ipv6CidrBlock.Builder> getIpv6CidrBlockSet() {
            return this.ipv6CidrBlockSet != null ? (Collection)this.ipv6CidrBlockSet.stream().map(Ipv6CidrBlock::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copy(ipv6CidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Ipv6CidrBlock ... ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet(Arrays.asList(ipv6CidrBlockSet));
            return this;
        }

        public final void setIpv6CidrBlockSet(Collection<Ipv6CidrBlock.BuilderImpl> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copyFromBuilder(ipv6CidrBlockSet);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final VpcPeeringConnectionOptionsDescription.Builder getPeeringOptions() {
            return this.peeringOptions != null ? this.peeringOptions.toBuilder() : null;
        }

        @Override
        public final Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions) {
            this.peeringOptions = peeringOptions;
            return this;
        }

        public final void setPeeringOptions(VpcPeeringConnectionOptionsDescription.BuilderImpl peeringOptions) {
            this.peeringOptions = peeringOptions != null ? peeringOptions.build() : null;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public VpcPeeringConnectionVpcInfo build() {
            return new VpcPeeringConnectionVpcInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
        public Builder cidrBlock(String var1);

        public Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> var1);

        public Builder ipv6CidrBlockSet(Ipv6CidrBlock ... var1);

        public Builder ownerId(String var1);

        public Builder peeringOptions(VpcPeeringConnectionOptionsDescription var1);

        public Builder vpcId(String var1);
    }
}

