/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UserBucket
implements ToCopyableBuilder<Builder, UserBucket> {
    private final String s3Bucket;
    private final String s3Key;

    private UserBucket(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.s3Bucket() == null ? 0 : this.s3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.s3Key() == null ? 0 : this.s3Key().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserBucket)) {
            return false;
        }
        UserBucket other = (UserBucket)obj;
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Key() == null ^ this.s3Key() == null) {
            return false;
        }
        return other.s3Key() == null || other.s3Key().equals(this.s3Key());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3Key() != null) {
            sb.append("S3Key: ").append(this.s3Key()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.of(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.of(clazz.cast(this.s3Key()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(UserBucket model) {
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public UserBucket build() {
            return new UserBucket(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserBucket> {
        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);
    }
}

