/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.InstanceMonitoring;
import software.amazon.awssdk.services.ec2.model.InstanceMonitoringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnmonitorInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UnmonitorInstancesResponse> {
    private final List<InstanceMonitoring> instanceMonitorings;

    private UnmonitorInstancesResponse(BuilderImpl builder) {
        this.instanceMonitorings = builder.instanceMonitorings;
    }

    public List<InstanceMonitoring> instanceMonitorings() {
        return this.instanceMonitorings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceMonitorings() == null ? 0 : this.instanceMonitorings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnmonitorInstancesResponse)) {
            return false;
        }
        UnmonitorInstancesResponse other = (UnmonitorInstancesResponse)((Object)obj);
        if (other.instanceMonitorings() == null ^ this.instanceMonitorings() == null) {
            return false;
        }
        return other.instanceMonitorings() == null || other.instanceMonitorings().equals(this.instanceMonitorings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceMonitorings() != null) {
            sb.append("InstanceMonitorings: ").append(this.instanceMonitorings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceMonitorings": {
                return Optional.of(clazz.cast(this.instanceMonitorings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceMonitoring> instanceMonitorings;

        private BuilderImpl() {
        }

        private BuilderImpl(UnmonitorInstancesResponse model) {
            this.instanceMonitorings(model.instanceMonitorings);
        }

        public final Collection<InstanceMonitoring.Builder> getInstanceMonitorings() {
            return this.instanceMonitorings != null ? (Collection)this.instanceMonitorings.stream().map(InstanceMonitoring::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copy(instanceMonitorings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(InstanceMonitoring ... instanceMonitorings) {
            this.instanceMonitorings(Arrays.asList(instanceMonitorings));
            return this;
        }

        public final void setInstanceMonitorings(Collection<InstanceMonitoring.BuilderImpl> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copyFromBuilder(instanceMonitorings);
        }

        public UnmonitorInstancesResponse build() {
            return new UnmonitorInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnmonitorInstancesResponse> {
        public Builder instanceMonitorings(Collection<InstanceMonitoring> var1);

        public Builder instanceMonitorings(InstanceMonitoring ... var1);
    }
}

