/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotPlacement
implements ToCopyableBuilder<Builder, SpotPlacement> {
    private final String availabilityZone;
    private final String groupName;
    private final String tenancy;

    private SpotPlacement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.groupName = builder.groupName;
        this.tenancy = builder.tenancy;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String groupName() {
        return this.groupName;
    }

    public Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public String tenancyString() {
        return this.tenancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.tenancyString() == null ? 0 : this.tenancyString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPlacement)) {
            return false;
        }
        SpotPlacement other = (SpotPlacement)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.tenancyString() == null ^ this.tenancyString() == null) {
            return false;
        }
        return other.tenancyString() == null || other.tenancyString().equals(this.tenancyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.tenancyString() != null) {
            sb.append("Tenancy: ").append(this.tenancyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "Tenancy": {
                return Optional.of(clazz.cast(this.tenancyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String groupName;
        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPlacement model) {
            this.availabilityZone(model.availabilityZone);
            this.groupName(model.groupName);
            this.tenancy(model.tenancy);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public SpotPlacement build() {
            return new SpotPlacement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotPlacement> {
        public Builder availabilityZone(String var1);

        public Builder groupName(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);
    }
}

