/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ActivityStatus;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotFleetRequestConfig
implements ToCopyableBuilder<Builder, SpotFleetRequestConfig> {
    private final String activityStatus;
    private final Instant createTime;
    private final SpotFleetRequestConfigData spotFleetRequestConfig;
    private final String spotFleetRequestId;
    private final String spotFleetRequestState;

    private SpotFleetRequestConfig(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.spotFleetRequestState = builder.spotFleetRequestState;
    }

    public ActivityStatus activityStatus() {
        return ActivityStatus.fromValue(this.activityStatus);
    }

    public String activityStatusString() {
        return this.activityStatus;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public SpotFleetRequestConfigData spotFleetRequestConfig() {
        return this.spotFleetRequestConfig;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public BatchState spotFleetRequestState() {
        return BatchState.fromValue(this.spotFleetRequestState);
    }

    public String spotFleetRequestStateString() {
        return this.spotFleetRequestState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activityStatusString() == null ? 0 : this.activityStatusString().hashCode());
        hashCode = 31 * hashCode + (this.createTime() == null ? 0 : this.createTime().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestConfig() == null ? 0 : this.spotFleetRequestConfig().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestId() == null ? 0 : this.spotFleetRequestId().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestStateString() == null ? 0 : this.spotFleetRequestStateString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfig)) {
            return false;
        }
        SpotFleetRequestConfig other = (SpotFleetRequestConfig)obj;
        if (other.activityStatusString() == null ^ this.activityStatusString() == null) {
            return false;
        }
        if (other.activityStatusString() != null && !other.activityStatusString().equals(this.activityStatusString())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.spotFleetRequestConfig() == null ^ this.spotFleetRequestConfig() == null) {
            return false;
        }
        if (other.spotFleetRequestConfig() != null && !other.spotFleetRequestConfig().equals(this.spotFleetRequestConfig())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        if (other.spotFleetRequestId() != null && !other.spotFleetRequestId().equals(this.spotFleetRequestId())) {
            return false;
        }
        if (other.spotFleetRequestStateString() == null ^ this.spotFleetRequestStateString() == null) {
            return false;
        }
        return other.spotFleetRequestStateString() == null || other.spotFleetRequestStateString().equals(this.spotFleetRequestStateString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.activityStatusString() != null) {
            sb.append("ActivityStatus: ").append(this.activityStatusString()).append(",");
        }
        if (this.createTime() != null) {
            sb.append("CreateTime: ").append(this.createTime()).append(",");
        }
        if (this.spotFleetRequestConfig() != null) {
            sb.append("SpotFleetRequestConfig: ").append(this.spotFleetRequestConfig()).append(",");
        }
        if (this.spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(this.spotFleetRequestId()).append(",");
        }
        if (this.spotFleetRequestStateString() != null) {
            sb.append("SpotFleetRequestState: ").append(this.spotFleetRequestStateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityStatus": {
                return Optional.of(clazz.cast(this.activityStatusString()));
            }
            case "CreateTime": {
                return Optional.of(clazz.cast(this.createTime()));
            }
            case "SpotFleetRequestConfig": {
                return Optional.of(clazz.cast(this.spotFleetRequestConfig()));
            }
            case "SpotFleetRequestId": {
                return Optional.of(clazz.cast(this.spotFleetRequestId()));
            }
            case "SpotFleetRequestState": {
                return Optional.of(clazz.cast(this.spotFleetRequestStateString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String activityStatus;
        private Instant createTime;
        private SpotFleetRequestConfigData spotFleetRequestConfig;
        private String spotFleetRequestId;
        private String spotFleetRequestState;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfig model) {
            this.activityStatus(model.activityStatus);
            this.createTime(model.createTime);
            this.spotFleetRequestConfig(model.spotFleetRequestConfig);
            this.spotFleetRequestId(model.spotFleetRequestId);
            this.spotFleetRequestState(model.spotFleetRequestState);
        }

        public final String getActivityStatus() {
            return this.activityStatus;
        }

        @Override
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        public final Builder activityStatus(ActivityStatus activityStatus) {
            this.activityStatus(activityStatus.toString());
            return this;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return this.spotFleetRequestConfig != null ? this.spotFleetRequestConfig.toBuilder() : null;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final String getSpotFleetRequestState() {
            return this.spotFleetRequestState;
        }

        @Override
        public final Builder spotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
            return this;
        }

        @Override
        public final Builder spotFleetRequestState(BatchState spotFleetRequestState) {
            this.spotFleetRequestState(spotFleetRequestState.toString());
            return this;
        }

        public final void setSpotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
        }

        public SpotFleetRequestConfig build() {
            return new SpotFleetRequestConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotFleetRequestConfig> {
        public Builder activityStatus(String var1);

        public Builder activityStatus(ActivityStatus var1);

        public Builder createTime(Instant var1);

        public Builder spotFleetRequestConfig(SpotFleetRequestConfigData var1);

        public Builder spotFleetRequestId(String var1);

        public Builder spotFleetRequestState(String var1);

        public Builder spotFleetRequestState(BatchState var1);
    }
}

