/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMappingSetCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterfaceSetCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesSecurityGroupIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduledInstancesLaunchSpecification
implements ToCopyableBuilder<Builder, ScheduledInstancesLaunchSpecification> {
    private final List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings;
    private final Boolean ebsOptimized;
    private final ScheduledInstancesIamInstanceProfile iamInstanceProfile;
    private final String imageId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final ScheduledInstancesMonitoring monitoring;
    private final List<ScheduledInstancesNetworkInterface> networkInterfaces;
    private final ScheduledInstancesPlacement placement;
    private final String ramdiskId;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final String userData;

    private ScheduledInstancesLaunchSpecification(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    public List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public ScheduledInstancesIamInstanceProfile iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String imageId() {
        return this.imageId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public ScheduledInstancesMonitoring monitoring() {
        return this.monitoring;
    }

    public List<ScheduledInstancesNetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public ScheduledInstancesPlacement placement() {
        return this.placement;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String userData() {
        return this.userData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.iamInstanceProfile() == null ? 0 : this.iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.keyName() == null ? 0 : this.keyName().hashCode());
        hashCode = 31 * hashCode + (this.monitoring() == null ? 0 : this.monitoring().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaces() == null ? 0 : this.networkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesLaunchSpecification)) {
            return false;
        }
        ScheduledInstancesLaunchSpecification other = (ScheduledInstancesLaunchSpecification)obj;
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        return other.userData() == null || other.userData().equals(this.userData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.iamInstanceProfile()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (this.monitoring() != null) {
            sb.append("Monitoring: ").append(this.monitoring()).append(",");
        }
        if (this.networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.networkInterfaces()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.of(clazz.cast(this.iamInstanceProfile()));
            }
            case "ImageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "KernelId": {
                return Optional.of(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
            case "Monitoring": {
                return Optional.of(clazz.cast(this.monitoring()));
            }
            case "NetworkInterfaces": {
                return Optional.of(clazz.cast(this.networkInterfaces()));
            }
            case "Placement": {
                return Optional.of(clazz.cast(this.placement()));
            }
            case "RamdiskId": {
                return Optional.of(clazz.cast(this.ramdiskId()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "UserData": {
                return Optional.of(clazz.cast(this.userData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings;
        private Boolean ebsOptimized;
        private ScheduledInstancesIamInstanceProfile iamInstanceProfile;
        private String imageId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private ScheduledInstancesMonitoring monitoring;
        private List<ScheduledInstancesNetworkInterface> networkInterfaces;
        private ScheduledInstancesPlacement placement;
        private String ramdiskId;
        private List<String> securityGroupIds;
        private String subnetId;
        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesLaunchSpecification model) {
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.monitoring(model.monitoring);
            this.networkInterfaces(model.networkInterfaces);
            this.placement(model.placement);
            this.ramdiskId(model.ramdiskId);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.userData(model.userData);
        }

        public final Collection<ScheduledInstancesBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(ScheduledInstancesBlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final ScheduledInstancesIamInstanceProfile.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(ScheduledInstancesIamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final ScheduledInstancesMonitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(ScheduledInstancesMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(ScheduledInstancesMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final Collection<ScheduledInstancesNetworkInterface.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(ScheduledInstancesNetworkInterface::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(ScheduledInstancesNetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<ScheduledInstancesNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copyFromBuilder(networkInterfaces);
        }

        public final ScheduledInstancesPlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(ScheduledInstancesPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(ScheduledInstancesPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public ScheduledInstancesLaunchSpecification build() {
            return new ScheduledInstancesLaunchSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledInstancesLaunchSpecification> {
        public Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder monitoring(ScheduledInstancesMonitoring var1);

        public Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> var1);

        public Builder networkInterfaces(ScheduledInstancesNetworkInterface ... var1);

        public Builder placement(ScheduledInstancesPlacement var1);

        public Builder ramdiskId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder userData(String var1);
    }
}

