/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetNetworkInterfaceAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ResetNetworkInterfaceAttributeRequest> {
    private final String networkInterfaceId;
    private final String sourceDestCheck;

    private ResetNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.sourceDestCheck() == null ? 0 : this.sourceDestCheck().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ResetNetworkInterfaceAttributeRequest other = (ResetNetworkInterfaceAttributeRequest)((Object)obj);
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        return other.sourceDestCheck() == null || other.sourceDestCheck().equals(this.sourceDestCheck());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.sourceDestCheck()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "SourceDestCheck": {
                return Optional.of(clazz.cast(this.sourceDestCheck()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private String sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetNetworkInterfaceAttributeRequest model) {
            this.networkInterfaceId(model.networkInterfaceId);
            this.sourceDestCheck(model.sourceDestCheck);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(String sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(String sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public ResetNetworkInterfaceAttributeRequest build() {
            return new ResetNetworkInterfaceAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResetNetworkInterfaceAttributeRequest> {
        public Builder networkInterfaceId(String var1);

        public Builder sourceDestCheck(String var1);
    }
}

