/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstancesModificationResult
implements ToCopyableBuilder<Builder, ReservedInstancesModificationResult> {
    private final String reservedInstancesId;
    private final ReservedInstancesConfiguration targetConfiguration;

    private ReservedInstancesModificationResult(BuilderImpl builder) {
        this.reservedInstancesId = builder.reservedInstancesId;
        this.targetConfiguration = builder.targetConfiguration;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public ReservedInstancesConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedInstancesId() == null ? 0 : this.reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + (this.targetConfiguration() == null ? 0 : this.targetConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModificationResult)) {
            return false;
        }
        ReservedInstancesModificationResult other = (ReservedInstancesModificationResult)obj;
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.targetConfiguration() == null ^ this.targetConfiguration() == null) {
            return false;
        }
        return other.targetConfiguration() == null || other.targetConfiguration().equals(this.targetConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(this.reservedInstancesId()).append(",");
        }
        if (this.targetConfiguration() != null) {
            sb.append("TargetConfiguration: ").append(this.targetConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstancesId": {
                return Optional.of(clazz.cast(this.reservedInstancesId()));
            }
            case "TargetConfiguration": {
                return Optional.of(clazz.cast(this.targetConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedInstancesId;
        private ReservedInstancesConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModificationResult model) {
            this.reservedInstancesId(model.reservedInstancesId);
            this.targetConfiguration(model.targetConfiguration);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final ReservedInstancesConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetConfiguration(ReservedInstancesConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final void setTargetConfiguration(ReservedInstancesConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        public ReservedInstancesModificationResult build() {
            return new ReservedInstancesModificationResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstancesModificationResult> {
        public Builder reservedInstancesId(String var1);

        public Builder targetConfiguration(ReservedInstancesConfiguration var1);
    }
}

