/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ReservationValue;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstanceReservationValue
implements ToCopyableBuilder<Builder, ReservedInstanceReservationValue> {
    private final ReservationValue reservationValue;
    private final String reservedInstanceId;

    private ReservedInstanceReservationValue(BuilderImpl builder) {
        this.reservationValue = builder.reservationValue;
        this.reservedInstanceId = builder.reservedInstanceId;
    }

    public ReservationValue reservationValue() {
        return this.reservationValue;
    }

    public String reservedInstanceId() {
        return this.reservedInstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservationValue() == null ? 0 : this.reservationValue().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstanceId() == null ? 0 : this.reservedInstanceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstanceReservationValue)) {
            return false;
        }
        ReservedInstanceReservationValue other = (ReservedInstanceReservationValue)obj;
        if (other.reservationValue() == null ^ this.reservationValue() == null) {
            return false;
        }
        if (other.reservationValue() != null && !other.reservationValue().equals(this.reservationValue())) {
            return false;
        }
        if (other.reservedInstanceId() == null ^ this.reservedInstanceId() == null) {
            return false;
        }
        return other.reservedInstanceId() == null || other.reservedInstanceId().equals(this.reservedInstanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reservationValue() != null) {
            sb.append("ReservationValue: ").append(this.reservationValue()).append(",");
        }
        if (this.reservedInstanceId() != null) {
            sb.append("ReservedInstanceId: ").append(this.reservedInstanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservationValue": {
                return Optional.of(clazz.cast(this.reservationValue()));
            }
            case "ReservedInstanceId": {
                return Optional.of(clazz.cast(this.reservedInstanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ReservationValue reservationValue;
        private String reservedInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstanceReservationValue model) {
            this.reservationValue(model.reservationValue);
            this.reservedInstanceId(model.reservedInstanceId);
        }

        public final ReservationValue.Builder getReservationValue() {
            return this.reservationValue != null ? this.reservationValue.toBuilder() : null;
        }

        @Override
        public final Builder reservationValue(ReservationValue reservationValue) {
            this.reservationValue = reservationValue;
            return this;
        }

        public final void setReservationValue(ReservationValue.BuilderImpl reservationValue) {
            this.reservationValue = reservationValue != null ? reservationValue.build() : null;
        }

        public final String getReservedInstanceId() {
            return this.reservedInstanceId;
        }

        @Override
        public final Builder reservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
            return this;
        }

        public final void setReservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
        }

        public ReservedInstanceReservationValue build() {
            return new ReservedInstanceReservationValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstanceReservationValue> {
        public Builder reservationValue(ReservationValue var1);

        public Builder reservedInstanceId(String var1);
    }
}

