/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PriceSchedule
implements ToCopyableBuilder<Builder, PriceSchedule> {
    private final Boolean active;
    private final String currencyCode;
    private final Double price;
    private final Long term;

    private PriceSchedule(BuilderImpl builder) {
        this.active = builder.active;
        this.currencyCode = builder.currencyCode;
        this.price = builder.price;
        this.term = builder.term;
    }

    public Boolean active() {
        return this.active;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public Double price() {
        return this.price;
    }

    public Long term() {
        return this.term;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.active() == null ? 0 : this.active().hashCode());
        hashCode = 31 * hashCode + (this.currencyCodeString() == null ? 0 : this.currencyCodeString().hashCode());
        hashCode = 31 * hashCode + (this.price() == null ? 0 : this.price().hashCode());
        hashCode = 31 * hashCode + (this.term() == null ? 0 : this.term().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceSchedule)) {
            return false;
        }
        PriceSchedule other = (PriceSchedule)obj;
        if (other.active() == null ^ this.active() == null) {
            return false;
        }
        if (other.active() != null && !other.active().equals(this.active())) {
            return false;
        }
        if (other.currencyCodeString() == null ^ this.currencyCodeString() == null) {
            return false;
        }
        if (other.currencyCodeString() != null && !other.currencyCodeString().equals(this.currencyCodeString())) {
            return false;
        }
        if (other.price() == null ^ this.price() == null) {
            return false;
        }
        if (other.price() != null && !other.price().equals(this.price())) {
            return false;
        }
        if (other.term() == null ^ this.term() == null) {
            return false;
        }
        return other.term() == null || other.term().equals(this.term());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.active() != null) {
            sb.append("Active: ").append(this.active()).append(",");
        }
        if (this.currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCodeString()).append(",");
        }
        if (this.price() != null) {
            sb.append("Price: ").append(this.price()).append(",");
        }
        if (this.term() != null) {
            sb.append("Term: ").append(this.term()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Active": {
                return Optional.of(clazz.cast(this.active()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
            case "Price": {
                return Optional.of(clazz.cast(this.price()));
            }
            case "Term": {
                return Optional.of(clazz.cast(this.term()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean active;
        private String currencyCode;
        private Double price;
        private Long term;

        private BuilderImpl() {
        }

        private BuilderImpl(PriceSchedule model) {
            this.active(model.active);
            this.currencyCode(model.currencyCode);
            this.price(model.price);
            this.term(model.term);
        }

        public final Boolean getActive() {
            return this.active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Double getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        public final Long getTerm() {
            return this.term;
        }

        @Override
        public final Builder term(Long term) {
            this.term = term;
            return this;
        }

        public final void setTerm(Long term) {
            this.term = term;
        }

        public PriceSchedule build() {
            return new PriceSchedule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PriceSchedule> {
        public Builder active(Boolean var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder price(Double var1);

        public Builder term(Long var1);
    }
}

