/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.NetworkAclAssociation;
import software.amazon.awssdk.services.ec2.model.NetworkAclAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkAclEntry;
import software.amazon.awssdk.services.ec2.model.NetworkAclEntryListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkAcl
implements ToCopyableBuilder<Builder, NetworkAcl> {
    private final List<NetworkAclAssociation> associations;
    private final List<NetworkAclEntry> entries;
    private final Boolean isDefault;
    private final String networkAclId;
    private final List<Tag> tags;
    private final String vpcId;

    private NetworkAcl(BuilderImpl builder) {
        this.associations = builder.associations;
        this.entries = builder.entries;
        this.isDefault = builder.isDefault;
        this.networkAclId = builder.networkAclId;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public List<NetworkAclAssociation> associations() {
        return this.associations;
    }

    public List<NetworkAclEntry> entries() {
        return this.entries;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public String networkAclId() {
        return this.networkAclId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associations() == null ? 0 : this.associations().hashCode());
        hashCode = 31 * hashCode + (this.entries() == null ? 0 : this.entries().hashCode());
        hashCode = 31 * hashCode + (this.isDefault() == null ? 0 : this.isDefault().hashCode());
        hashCode = 31 * hashCode + (this.networkAclId() == null ? 0 : this.networkAclId().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAcl)) {
            return false;
        }
        NetworkAcl other = (NetworkAcl)obj;
        if (other.associations() == null ^ this.associations() == null) {
            return false;
        }
        if (other.associations() != null && !other.associations().equals(this.associations())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        if (other.entries() != null && !other.entries().equals(this.entries())) {
            return false;
        }
        if (other.isDefault() == null ^ this.isDefault() == null) {
            return false;
        }
        if (other.isDefault() != null && !other.isDefault().equals(this.isDefault())) {
            return false;
        }
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associations() != null) {
            sb.append("Associations: ").append(this.associations()).append(",");
        }
        if (this.entries() != null) {
            sb.append("Entries: ").append(this.entries()).append(",");
        }
        if (this.isDefault() != null) {
            sb.append("IsDefault: ").append(this.isDefault()).append(",");
        }
        if (this.networkAclId() != null) {
            sb.append("NetworkAclId: ").append(this.networkAclId()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.of(clazz.cast(this.associations()));
            }
            case "Entries": {
                return Optional.of(clazz.cast(this.entries()));
            }
            case "IsDefault": {
                return Optional.of(clazz.cast(this.isDefault()));
            }
            case "NetworkAclId": {
                return Optional.of(clazz.cast(this.networkAclId()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<NetworkAclAssociation> associations;
        private List<NetworkAclEntry> entries;
        private Boolean isDefault;
        private String networkAclId;
        private List<Tag> tags;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAcl model) {
            this.associations(model.associations);
            this.entries(model.entries);
            this.isDefault(model.isDefault);
            this.networkAclId(model.networkAclId);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
        }

        public final Collection<NetworkAclAssociation.Builder> getAssociations() {
            return this.associations != null ? (Collection)this.associations.stream().map(NetworkAclAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<NetworkAclAssociation> associations) {
            this.associations = NetworkAclAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(NetworkAclAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        public final void setAssociations(Collection<NetworkAclAssociation.BuilderImpl> associations) {
            this.associations = NetworkAclAssociationListCopier.copyFromBuilder(associations);
        }

        public final Collection<NetworkAclEntry.Builder> getEntries() {
            return this.entries != null ? (Collection)this.entries.stream().map(NetworkAclEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<NetworkAclEntry> entries) {
            this.entries = NetworkAclEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(NetworkAclEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<NetworkAclEntry.BuilderImpl> entries) {
            this.entries = NetworkAclEntryListCopier.copyFromBuilder(entries);
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public NetworkAcl build() {
            return new NetworkAcl(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkAcl> {
        public Builder associations(Collection<NetworkAclAssociation> var1);

        public Builder associations(NetworkAclAssociation ... var1);

        public Builder entries(Collection<NetworkAclEntry> var1);

        public Builder entries(NetworkAclEntry ... var1);

        public Builder isDefault(Boolean var1);

        public Builder networkAclId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vpcId(String var1);
    }
}

