/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyVpcEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyVpcEndpointRequest> {
    private final List<String> addRouteTableIds;
    private final String policyDocument;
    private final List<String> removeRouteTableIds;
    private final Boolean resetPolicy;
    private final String vpcEndpointId;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        this.addRouteTableIds = builder.addRouteTableIds;
        this.policyDocument = builder.policyDocument;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.resetPolicy = builder.resetPolicy;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    public List<String> addRouteTableIds() {
        return this.addRouteTableIds;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public List<String> removeRouteTableIds() {
        return this.removeRouteTableIds;
    }

    public Boolean resetPolicy() {
        return this.resetPolicy;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.addRouteTableIds() == null ? 0 : this.addRouteTableIds().hashCode());
        hashCode = 31 * hashCode + (this.policyDocument() == null ? 0 : this.policyDocument().hashCode());
        hashCode = 31 * hashCode + (this.removeRouteTableIds() == null ? 0 : this.removeRouteTableIds().hashCode());
        hashCode = 31 * hashCode + (this.resetPolicy() == null ? 0 : this.resetPolicy().hashCode());
        hashCode = 31 * hashCode + (this.vpcEndpointId() == null ? 0 : this.vpcEndpointId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest)((Object)obj);
        if (other.addRouteTableIds() == null ^ this.addRouteTableIds() == null) {
            return false;
        }
        if (other.addRouteTableIds() != null && !other.addRouteTableIds().equals(this.addRouteTableIds())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.removeRouteTableIds() == null ^ this.removeRouteTableIds() == null) {
            return false;
        }
        if (other.removeRouteTableIds() != null && !other.removeRouteTableIds().equals(this.removeRouteTableIds())) {
            return false;
        }
        if (other.resetPolicy() == null ^ this.resetPolicy() == null) {
            return false;
        }
        if (other.resetPolicy() != null && !other.resetPolicy().equals(this.resetPolicy())) {
            return false;
        }
        if (other.vpcEndpointId() == null ^ this.vpcEndpointId() == null) {
            return false;
        }
        return other.vpcEndpointId() == null || other.vpcEndpointId().equals(this.vpcEndpointId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.addRouteTableIds() != null) {
            sb.append("AddRouteTableIds: ").append(this.addRouteTableIds()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        if (this.removeRouteTableIds() != null) {
            sb.append("RemoveRouteTableIds: ").append(this.removeRouteTableIds()).append(",");
        }
        if (this.resetPolicy() != null) {
            sb.append("ResetPolicy: ").append(this.resetPolicy()).append(",");
        }
        if (this.vpcEndpointId() != null) {
            sb.append("VpcEndpointId: ").append(this.vpcEndpointId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddRouteTableIds": {
                return Optional.of(clazz.cast(this.addRouteTableIds()));
            }
            case "PolicyDocument": {
                return Optional.of(clazz.cast(this.policyDocument()));
            }
            case "RemoveRouteTableIds": {
                return Optional.of(clazz.cast(this.removeRouteTableIds()));
            }
            case "ResetPolicy": {
                return Optional.of(clazz.cast(this.resetPolicy()));
            }
            case "VpcEndpointId": {
                return Optional.of(clazz.cast(this.vpcEndpointId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> addRouteTableIds;
        private String policyDocument;
        private List<String> removeRouteTableIds;
        private Boolean resetPolicy;
        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            this.addRouteTableIds(model.addRouteTableIds);
            this.policyDocument(model.policyDocument);
            this.removeRouteTableIds(model.removeRouteTableIds);
            this.resetPolicy(model.resetPolicy);
            this.vpcEndpointId(model.vpcEndpointId);
        }

        public final Collection<String> getAddRouteTableIds() {
            return this.addRouteTableIds;
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String ... addRouteTableIds) {
            this.addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            return this.removeRouteTableIds;
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String ... removeRouteTableIds) {
            this.removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
        }

        public final Boolean getResetPolicy() {
            return this.resetPolicy;
        }

        @Override
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        public Builder addRouteTableIds(Collection<String> var1);

        public Builder addRouteTableIds(String ... var1);

        public Builder policyDocument(String var1);

        public Builder removeRouteTableIds(Collection<String> var1);

        public Builder removeRouteTableIds(String ... var1);

        public Builder resetPolicy(Boolean var1);

        public Builder vpcEndpointId(String var1);
    }
}

