/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyVpcAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyVpcAttributeRequest> {
    private final Boolean enableDnsHostnames;
    private final Boolean enableDnsSupport;
    private final String vpcId;

    private ModifyVpcAttributeRequest(BuilderImpl builder) {
        this.enableDnsHostnames = builder.enableDnsHostnames;
        this.enableDnsSupport = builder.enableDnsSupport;
        this.vpcId = builder.vpcId;
    }

    public Boolean enableDnsHostnames() {
        return this.enableDnsHostnames;
    }

    public Boolean enableDnsSupport() {
        return this.enableDnsSupport;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enableDnsHostnames() == null ? 0 : this.enableDnsHostnames().hashCode());
        hashCode = 31 * hashCode + (this.enableDnsSupport() == null ? 0 : this.enableDnsSupport().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcAttributeRequest)) {
            return false;
        }
        ModifyVpcAttributeRequest other = (ModifyVpcAttributeRequest)((Object)obj);
        if (other.enableDnsHostnames() == null ^ this.enableDnsHostnames() == null) {
            return false;
        }
        if (other.enableDnsHostnames() != null && !other.enableDnsHostnames().equals(this.enableDnsHostnames())) {
            return false;
        }
        if (other.enableDnsSupport() == null ^ this.enableDnsSupport() == null) {
            return false;
        }
        if (other.enableDnsSupport() != null && !other.enableDnsSupport().equals(this.enableDnsSupport())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enableDnsHostnames() != null) {
            sb.append("EnableDnsHostnames: ").append(this.enableDnsHostnames()).append(",");
        }
        if (this.enableDnsSupport() != null) {
            sb.append("EnableDnsSupport: ").append(this.enableDnsSupport()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableDnsHostnames": {
                return Optional.of(clazz.cast(this.enableDnsHostnames()));
            }
            case "EnableDnsSupport": {
                return Optional.of(clazz.cast(this.enableDnsSupport()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableDnsHostnames;
        private Boolean enableDnsSupport;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcAttributeRequest model) {
            this.enableDnsHostnames(model.enableDnsHostnames);
            this.enableDnsSupport(model.enableDnsSupport);
            this.vpcId(model.vpcId);
        }

        public final Boolean getEnableDnsHostnames() {
            return this.enableDnsHostnames;
        }

        @Override
        public final Builder enableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        public final void setEnableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
        }

        public final Boolean getEnableDnsSupport() {
            return this.enableDnsSupport;
        }

        @Override
        public final Builder enableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        public final void setEnableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public ModifyVpcAttributeRequest build() {
            return new ModifyVpcAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyVpcAttributeRequest> {
        public Builder enableDnsHostnames(Boolean var1);

        public Builder enableDnsSupport(Boolean var1);

        public Builder vpcId(String var1);
    }
}

