/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceNetworkInterfaceAssociation
implements ToCopyableBuilder<Builder, InstanceNetworkInterfaceAssociation> {
    private final String ipOwnerId;
    private final String publicDnsName;
    private final String publicIp;

    private InstanceNetworkInterfaceAssociation(BuilderImpl builder) {
        this.ipOwnerId = builder.ipOwnerId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
    }

    public String ipOwnerId() {
        return this.ipOwnerId;
    }

    public String publicDnsName() {
        return this.publicDnsName;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ipOwnerId() == null ? 0 : this.ipOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.publicDnsName() == null ? 0 : this.publicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.publicIp() == null ? 0 : this.publicIp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceAssociation)) {
            return false;
        }
        InstanceNetworkInterfaceAssociation other = (InstanceNetworkInterfaceAssociation)obj;
        if (other.ipOwnerId() == null ^ this.ipOwnerId() == null) {
            return false;
        }
        if (other.ipOwnerId() != null && !other.ipOwnerId().equals(this.ipOwnerId())) {
            return false;
        }
        if (other.publicDnsName() == null ^ this.publicDnsName() == null) {
            return false;
        }
        if (other.publicDnsName() != null && !other.publicDnsName().equals(this.publicDnsName())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        return other.publicIp() == null || other.publicIp().equals(this.publicIp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ipOwnerId() != null) {
            sb.append("IpOwnerId: ").append(this.ipOwnerId()).append(",");
        }
        if (this.publicDnsName() != null) {
            sb.append("PublicDnsName: ").append(this.publicDnsName()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpOwnerId": {
                return Optional.of(clazz.cast(this.ipOwnerId()));
            }
            case "PublicDnsName": {
                return Optional.of(clazz.cast(this.publicDnsName()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ipOwnerId;
        private String publicDnsName;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceAssociation model) {
            this.ipOwnerId(model.ipOwnerId);
            this.publicDnsName(model.publicDnsName);
            this.publicIp(model.publicIp);
        }

        public final String getIpOwnerId() {
            return this.ipOwnerId;
        }

        @Override
        public final Builder ipOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
            return this;
        }

        public final void setIpOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public InstanceNetworkInterfaceAssociation build() {
            return new InstanceNetworkInterfaceAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceNetworkInterfaceAssociation> {
        public Builder ipOwnerId(String var1);

        public Builder publicDnsName(String var1);

        public Builder publicIp(String var1);
    }
}

