/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ExportEnvironment;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceExportDetails
implements ToCopyableBuilder<Builder, InstanceExportDetails> {
    private final String instanceId;
    private final String targetEnvironment;

    private InstanceExportDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public ExportEnvironment targetEnvironment() {
        return ExportEnvironment.fromValue(this.targetEnvironment);
    }

    public String targetEnvironmentString() {
        return this.targetEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.targetEnvironmentString() == null ? 0 : this.targetEnvironmentString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceExportDetails)) {
            return false;
        }
        InstanceExportDetails other = (InstanceExportDetails)obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.targetEnvironmentString() == null ^ this.targetEnvironmentString() == null) {
            return false;
        }
        return other.targetEnvironmentString() == null || other.targetEnvironmentString().equals(this.targetEnvironmentString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.targetEnvironmentString() != null) {
            sb.append("TargetEnvironment: ").append(this.targetEnvironmentString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "TargetEnvironment": {
                return Optional.of(clazz.cast(this.targetEnvironmentString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String targetEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceExportDetails model) {
            this.instanceId(model.instanceId);
            this.targetEnvironment(model.targetEnvironment);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTargetEnvironment() {
            return this.targetEnvironment;
        }

        @Override
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment.toString());
            return this;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        public InstanceExportDetails build() {
            return new InstanceExportDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceExportDetails> {
        public Builder instanceId(String var1);

        public Builder targetEnvironment(String var1);

        public Builder targetEnvironment(ExportEnvironment var1);
    }
}

