/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.DiskImageDescription;
import software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportVolumeTaskDetails
implements ToCopyableBuilder<Builder, ImportVolumeTaskDetails> {
    private final String availabilityZone;
    private final Long bytesConverted;
    private final String description;
    private final DiskImageDescription image;
    private final DiskImageVolumeDescription volume;

    private ImportVolumeTaskDetails(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.bytesConverted = builder.bytesConverted;
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Long bytesConverted() {
        return this.bytesConverted;
    }

    public String description() {
        return this.description;
    }

    public DiskImageDescription image() {
        return this.image;
    }

    public DiskImageVolumeDescription volume() {
        return this.volume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.bytesConverted() == null ? 0 : this.bytesConverted().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.volume() == null ? 0 : this.volume().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeTaskDetails)) {
            return false;
        }
        ImportVolumeTaskDetails other = (ImportVolumeTaskDetails)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.bytesConverted() == null ^ this.bytesConverted() == null) {
            return false;
        }
        if (other.bytesConverted() != null && !other.bytesConverted().equals(this.bytesConverted())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.volume() == null ^ this.volume() == null) {
            return false;
        }
        return other.volume() == null || other.volume().equals(this.volume());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.bytesConverted() != null) {
            sb.append("BytesConverted: ").append(this.bytesConverted()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.volume() != null) {
            sb.append("Volume: ").append(this.volume()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "BytesConverted": {
                return Optional.of(clazz.cast(this.bytesConverted()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "Volume": {
                return Optional.of(clazz.cast(this.volume()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long bytesConverted;
        private String description;
        private DiskImageDescription image;
        private DiskImageVolumeDescription volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeTaskDetails model) {
            this.availabilityZone(model.availabilityZone);
            this.bytesConverted(model.bytesConverted);
            this.description(model.description);
            this.image(model.image);
            this.volume(model.volume);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getBytesConverted() {
            return this.bytesConverted;
        }

        @Override
        public final Builder bytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
            return this;
        }

        public final void setBytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDescription.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(DiskImageDescription image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDescription.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final DiskImageVolumeDescription.Builder getVolume() {
            return this.volume != null ? this.volume.toBuilder() : null;
        }

        @Override
        public final Builder volume(DiskImageVolumeDescription volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(DiskImageVolumeDescription.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        public ImportVolumeTaskDetails build() {
            return new ImportVolumeTaskDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportVolumeTaskDetails> {
        public Builder availabilityZone(String var1);

        public Builder bytesConverted(Long var1);

        public Builder description(String var1);

        public Builder image(DiskImageDescription var1);

        public Builder volume(DiskImageVolumeDescription var1);
    }
}

