/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.UserData;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportInstanceLaunchSpecification
implements ToCopyableBuilder<Builder, ImportInstanceLaunchSpecification> {
    private final String additionalInfo;
    private final String architecture;
    private final List<String> groupIds;
    private final List<String> groupNames;
    private final String instanceInitiatedShutdownBehavior;
    private final String instanceType;
    private final Boolean monitoring;
    private final Placement placement;
    private final String privateIpAddress;
    private final String subnetId;
    private final UserData userData;

    private ImportInstanceLaunchSpecification(BuilderImpl builder) {
        this.additionalInfo = builder.additionalInfo;
        this.architecture = builder.architecture;
        this.groupIds = builder.groupIds;
        this.groupNames = builder.groupNames;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.privateIpAddress = builder.privateIpAddress;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(this.architecture);
    }

    public String architectureString() {
        return this.architecture;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(this.instanceInitiatedShutdownBehavior);
    }

    public String instanceInitiatedShutdownBehaviorString() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeString() {
        return this.instanceType;
    }

    public Boolean monitoring() {
        return this.monitoring;
    }

    public Placement placement() {
        return this.placement;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public UserData userData() {
        return this.userData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.additionalInfo() == null ? 0 : this.additionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.architectureString() == null ? 0 : this.architectureString().hashCode());
        hashCode = 31 * hashCode + (this.groupIds() == null ? 0 : this.groupIds().hashCode());
        hashCode = 31 * hashCode + (this.groupNames() == null ? 0 : this.groupNames().hashCode());
        hashCode = 31 * hashCode + (this.instanceInitiatedShutdownBehaviorString() == null ? 0 : this.instanceInitiatedShutdownBehaviorString().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypeString() == null ? 0 : this.instanceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.monitoring() == null ? 0 : this.monitoring().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceLaunchSpecification)) {
            return false;
        }
        ImportInstanceLaunchSpecification other = (ImportInstanceLaunchSpecification)obj;
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        if (other.additionalInfo() != null && !other.additionalInfo().equals(this.additionalInfo())) {
            return false;
        }
        if (other.architectureString() == null ^ this.architectureString() == null) {
            return false;
        }
        if (other.architectureString() != null && !other.architectureString().equals(this.architectureString())) {
            return false;
        }
        if (other.groupIds() == null ^ this.groupIds() == null) {
            return false;
        }
        if (other.groupIds() != null && !other.groupIds().equals(this.groupIds())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        if (other.groupNames() != null && !other.groupNames().equals(this.groupNames())) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehaviorString() == null ^ this.instanceInitiatedShutdownBehaviorString() == null) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehaviorString() != null && !other.instanceInitiatedShutdownBehaviorString().equals(this.instanceInitiatedShutdownBehaviorString())) {
            return false;
        }
        if (other.instanceTypeString() == null ^ this.instanceTypeString() == null) {
            return false;
        }
        if (other.instanceTypeString() != null && !other.instanceTypeString().equals(this.instanceTypeString())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        return other.userData() == null || other.userData().equals(this.userData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        if (this.architectureString() != null) {
            sb.append("Architecture: ").append(this.architectureString()).append(",");
        }
        if (this.groupIds() != null) {
            sb.append("GroupIds: ").append(this.groupIds()).append(",");
        }
        if (this.groupNames() != null) {
            sb.append("GroupNames: ").append(this.groupNames()).append(",");
        }
        if (this.instanceInitiatedShutdownBehaviorString() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.instanceInitiatedShutdownBehaviorString()).append(",");
        }
        if (this.instanceTypeString() != null) {
            sb.append("InstanceType: ").append(this.instanceTypeString()).append(",");
        }
        if (this.monitoring() != null) {
            sb.append("Monitoring: ").append(this.monitoring()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalInfo": {
                return Optional.of(clazz.cast(this.additionalInfo()));
            }
            case "Architecture": {
                return Optional.of(clazz.cast(this.architectureString()));
            }
            case "GroupIds": {
                return Optional.of(clazz.cast(this.groupIds()));
            }
            case "GroupNames": {
                return Optional.of(clazz.cast(this.groupNames()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.of(clazz.cast(this.instanceInitiatedShutdownBehaviorString()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeString()));
            }
            case "Monitoring": {
                return Optional.of(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.of(clazz.cast(this.placement()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "UserData": {
                return Optional.of(clazz.cast(this.userData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String additionalInfo;
        private String architecture;
        private List<String> groupIds;
        private List<String> groupNames;
        private String instanceInitiatedShutdownBehavior;
        private String instanceType;
        private Boolean monitoring;
        private Placement placement;
        private String privateIpAddress;
        private String subnetId;
        private UserData userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceLaunchSpecification model) {
            this.additionalInfo(model.additionalInfo);
            this.architecture(model.architecture);
            this.groupIds(model.groupIds);
            this.groupNames(model.groupNames);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.instanceType(model.instanceType);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.privateIpAddress(model.privateIpAddress);
            this.subnetId(model.subnetId);
            this.userData(model.userData);
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<String> getGroupIds() {
            return this.groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String ... groupIds) {
            this.groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Boolean getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final Builder monitoring(Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final UserData.Builder getUserData() {
            return this.userData != null ? this.userData.toBuilder() : null;
        }

        @Override
        public final Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(UserData.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        public ImportInstanceLaunchSpecification build() {
            return new ImportInstanceLaunchSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportInstanceLaunchSpecification> {
        public Builder additionalInfo(String var1);

        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder groupIds(Collection<String> var1);

        public Builder groupIds(String ... var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder monitoring(Boolean var1);

        public Builder placement(Placement var1);

        public Builder privateIpAddress(String var1);

        public Builder subnetId(String var1);

        public Builder userData(UserData var1);
    }
}

