/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceStatusRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeInstanceStatusRequest> {
    private final List<Filter> filters;
    private final List<String> instanceIds;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean includeAllInstances;

    private DescribeInstanceStatusRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.instanceIds = builder.instanceIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeAllInstances = builder.includeAllInstances;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Boolean includeAllInstances() {
        return this.includeAllInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.instanceIds() == null ? 0 : this.instanceIds().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.includeAllInstances() == null ? 0 : this.includeAllInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStatusRequest)) {
            return false;
        }
        DescribeInstanceStatusRequest other = (DescribeInstanceStatusRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.includeAllInstances() == null ^ this.includeAllInstances() == null) {
            return false;
        }
        return other.includeAllInstances() == null || other.includeAllInstances().equals(this.includeAllInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.includeAllInstances() != null) {
            sb.append("IncludeAllInstances: ").append(this.includeAllInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "InstanceIds": {
                return Optional.of(clazz.cast(this.instanceIds()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "IncludeAllInstances": {
                return Optional.of(clazz.cast(this.includeAllInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> instanceIds;
        private Integer maxResults;
        private String nextToken;
        private Boolean includeAllInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceStatusRequest model) {
            this.filters(model.filters);
            this.instanceIds(model.instanceIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.includeAllInstances(model.includeAllInstances);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getIncludeAllInstances() {
            return this.includeAllInstances;
        }

        @Override
        public final Builder includeAllInstances(Boolean includeAllInstances) {
            this.includeAllInstances = includeAllInstances;
            return this;
        }

        public final void setIncludeAllInstances(Boolean includeAllInstances) {
            this.includeAllInstances = includeAllInstances;
        }

        public DescribeInstanceStatusRequest build() {
            return new DescribeInstanceStatusRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstanceStatusRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder includeAllInstances(Boolean var1);
    }
}

