/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.Host;
import software.amazon.awssdk.services.ec2.model.HostListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHostsResponse> {
    private final List<Host> hosts;
    private final String nextToken;

    private DescribeHostsResponse(BuilderImpl builder) {
        this.hosts = builder.hosts;
        this.nextToken = builder.nextToken;
    }

    public List<Host> hosts() {
        return this.hosts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hosts() == null ? 0 : this.hosts().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsResponse)) {
            return false;
        }
        DescribeHostsResponse other = (DescribeHostsResponse)((Object)obj);
        if (other.hosts() == null ^ this.hosts() == null) {
            return false;
        }
        if (other.hosts() != null && !other.hosts().equals(this.hosts())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hosts() != null) {
            sb.append("Hosts: ").append(this.hosts()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Hosts": {
                return Optional.of(clazz.cast(this.hosts()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Host> hosts;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostsResponse model) {
            this.hosts(model.hosts);
            this.nextToken(model.nextToken);
        }

        public final Collection<Host.Builder> getHosts() {
            return this.hosts != null ? (Collection)this.hosts.stream().map(Host::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hosts(Collection<Host> hosts) {
            this.hosts = HostListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(Host ... hosts) {
            this.hosts(Arrays.asList(hosts));
            return this;
        }

        public final void setHosts(Collection<Host.BuilderImpl> hosts) {
            this.hosts = HostListCopier.copyFromBuilder(hosts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeHostsResponse build() {
            return new DescribeHostsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHostsResponse> {
        public Builder hosts(Collection<Host> var1);

        public Builder hosts(Host ... var1);

        public Builder nextToken(String var1);
    }
}

