/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVpnConnectionRouteRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateVpnConnectionRouteRequest> {
    private final String destinationCidrBlock;
    private final String vpnConnectionId;

    private CreateVpnConnectionRouteRequest(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.vpnConnectionId = builder.vpnConnectionId;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationCidrBlock() == null ? 0 : this.destinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.vpnConnectionId() == null ? 0 : this.vpnConnectionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionRouteRequest)) {
            return false;
        }
        CreateVpnConnectionRouteRequest other = (CreateVpnConnectionRouteRequest)((Object)obj);
        if (other.destinationCidrBlock() == null ^ this.destinationCidrBlock() == null) {
            return false;
        }
        if (other.destinationCidrBlock() != null && !other.destinationCidrBlock().equals(this.destinationCidrBlock())) {
            return false;
        }
        if (other.vpnConnectionId() == null ^ this.vpnConnectionId() == null) {
            return false;
        }
        return other.vpnConnectionId() == null || other.vpnConnectionId().equals(this.vpnConnectionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.destinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(this.destinationCidrBlock()).append(",");
        }
        if (this.vpnConnectionId() != null) {
            sb.append("VpnConnectionId: ").append(this.vpnConnectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.of(clazz.cast(this.destinationCidrBlock()));
            }
            case "VpnConnectionId": {
                return Optional.of(clazz.cast(this.vpnConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String vpnConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnConnectionRouteRequest model) {
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.vpnConnectionId(model.vpnConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        public CreateVpnConnectionRouteRequest build() {
            return new CreateVpnConnectionRouteRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateVpnConnectionRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder vpnConnectionId(String var1);
    }
}

