/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelConversionTaskRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CancelConversionTaskRequest> {
    private final String conversionTaskId;
    private final String reasonMessage;

    private CancelConversionTaskRequest(BuilderImpl builder) {
        this.conversionTaskId = builder.conversionTaskId;
        this.reasonMessage = builder.reasonMessage;
    }

    public String conversionTaskId() {
        return this.conversionTaskId;
    }

    public String reasonMessage() {
        return this.reasonMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.conversionTaskId() == null ? 0 : this.conversionTaskId().hashCode());
        hashCode = 31 * hashCode + (this.reasonMessage() == null ? 0 : this.reasonMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelConversionTaskRequest)) {
            return false;
        }
        CancelConversionTaskRequest other = (CancelConversionTaskRequest)((Object)obj);
        if (other.conversionTaskId() == null ^ this.conversionTaskId() == null) {
            return false;
        }
        if (other.conversionTaskId() != null && !other.conversionTaskId().equals(this.conversionTaskId())) {
            return false;
        }
        if (other.reasonMessage() == null ^ this.reasonMessage() == null) {
            return false;
        }
        return other.reasonMessage() == null || other.reasonMessage().equals(this.reasonMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.conversionTaskId() != null) {
            sb.append("ConversionTaskId: ").append(this.conversionTaskId()).append(",");
        }
        if (this.reasonMessage() != null) {
            sb.append("ReasonMessage: ").append(this.reasonMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConversionTaskId": {
                return Optional.of(clazz.cast(this.conversionTaskId()));
            }
            case "ReasonMessage": {
                return Optional.of(clazz.cast(this.reasonMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String conversionTaskId;
        private String reasonMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelConversionTaskRequest model) {
            this.conversionTaskId(model.conversionTaskId);
            this.reasonMessage(model.reasonMessage);
        }

        public final String getConversionTaskId() {
            return this.conversionTaskId;
        }

        @Override
        public final Builder conversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
            return this;
        }

        public final void setConversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
        }

        public final String getReasonMessage() {
            return this.reasonMessage;
        }

        @Override
        public final Builder reasonMessage(String reasonMessage) {
            this.reasonMessage = reasonMessage;
            return this;
        }

        public final void setReasonMessage(String reasonMessage) {
            this.reasonMessage = reasonMessage;
        }

        public CancelConversionTaskRequest build() {
            return new CancelConversionTaskRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelConversionTaskRequest> {
        public Builder conversionTaskId(String var1);

        public Builder reasonMessage(String var1);
    }
}

