/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Storage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BundleInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BundleInstanceRequest> {
    private final String instanceId;
    private final Storage storage;

    private BundleInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.storage = builder.storage;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Storage storage() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.storage() == null ? 0 : this.storage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInstanceRequest)) {
            return false;
        }
        BundleInstanceRequest other = (BundleInstanceRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.storage() == null ^ this.storage() == null) {
            return false;
        }
        return other.storage() == null || other.storage().equals(this.storage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.storage() != null) {
            sb.append("Storage: ").append(this.storage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Storage": {
                return Optional.of(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private Storage storage;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleInstanceRequest model) {
            this.instanceId(model.instanceId);
            this.storage(model.storage);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Storage.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(Storage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        public BundleInstanceRequest build() {
            return new BundleInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BundleInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder storage(Storage var1);
    }
}

