/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.GroupIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachClassicLinkVpcRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AttachClassicLinkVpcRequest> {
    private final List<String> groups;
    private final String instanceId;
    private final String vpcId;

    private AttachClassicLinkVpcRequest(BuilderImpl builder) {
        this.groups = builder.groups;
        this.instanceId = builder.instanceId;
        this.vpcId = builder.vpcId;
    }

    public List<String> groups() {
        return this.groups;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachClassicLinkVpcRequest)) {
            return false;
        }
        AttachClassicLinkVpcRequest other = (AttachClassicLinkVpcRequest)((Object)obj);
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> groups;
        private String instanceId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachClassicLinkVpcRequest model) {
            this.groups(model.groups);
            this.instanceId(model.instanceId);
            this.vpcId(model.vpcId);
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public AttachClassicLinkVpcRequest build() {
            return new AttachClassicLinkVpcRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachClassicLinkVpcRequest> {
        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder instanceId(String var1);

        public Builder vpcId(String var1);
    }
}

