/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateSubnetCidrBlockRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
    private final String ipv6CidrBlock;
    private final String subnetId;

    private AssociateSubnetCidrBlockRequest(BuilderImpl builder) {
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.subnetId = builder.subnetId;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ipv6CidrBlock() == null ? 0 : this.ipv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSubnetCidrBlockRequest)) {
            return false;
        }
        AssociateSubnetCidrBlockRequest other = (AssociateSubnetCidrBlockRequest)((Object)obj);
        if (other.ipv6CidrBlock() == null ^ this.ipv6CidrBlock() == null) {
            return false;
        }
        if (other.ipv6CidrBlock() != null && !other.ipv6CidrBlock().equals(this.ipv6CidrBlock())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        return other.subnetId() == null || other.subnetId().equals(this.subnetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ipv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(this.ipv6CidrBlock()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6CidrBlock": {
                return Optional.of(clazz.cast(this.ipv6CidrBlock()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ipv6CidrBlock;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSubnetCidrBlockRequest model) {
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.subnetId(model.subnetId);
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public AssociateSubnetCidrBlockRequest build() {
            return new AssociateSubnetCidrBlockRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
        public Builder ipv6CidrBlock(String var1);

        public Builder subnetId(String var1);
    }
}

