/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.InstanceHealthStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActiveInstance
implements ToCopyableBuilder<Builder, ActiveInstance> {
    private final String instanceId;
    private final String instanceType;
    private final String spotInstanceRequestId;
    private final String instanceHealth;

    private ActiveInstance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.instanceHealth = builder.instanceHealth;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public InstanceHealthStatus instanceHealth() {
        return InstanceHealthStatus.fromValue(this.instanceHealth);
    }

    public String instanceHealthString() {
        return this.instanceHealth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.spotInstanceRequestId() == null ? 0 : this.spotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + (this.instanceHealthString() == null ? 0 : this.instanceHealthString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveInstance)) {
            return false;
        }
        ActiveInstance other = (ActiveInstance)obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.spotInstanceRequestId() == null ^ this.spotInstanceRequestId() == null) {
            return false;
        }
        if (other.spotInstanceRequestId() != null && !other.spotInstanceRequestId().equals(this.spotInstanceRequestId())) {
            return false;
        }
        if (other.instanceHealthString() == null ^ this.instanceHealthString() == null) {
            return false;
        }
        return other.instanceHealthString() == null || other.instanceHealthString().equals(this.instanceHealthString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.spotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(this.spotInstanceRequestId()).append(",");
        }
        if (this.instanceHealthString() != null) {
            sb.append("InstanceHealth: ").append(this.instanceHealthString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "SpotInstanceRequestId": {
                return Optional.of(clazz.cast(this.spotInstanceRequestId()));
            }
            case "InstanceHealth": {
                return Optional.of(clazz.cast(this.instanceHealthString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String instanceType;
        private String spotInstanceRequestId;
        private String instanceHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveInstance model) {
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.spotInstanceRequestId(model.spotInstanceRequestId);
            this.instanceHealth(model.instanceHealth);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getInstanceHealth() {
            return this.instanceHealth;
        }

        @Override
        public final Builder instanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
            return this;
        }

        @Override
        public final Builder instanceHealth(InstanceHealthStatus instanceHealth) {
            this.instanceHealth(instanceHealth.toString());
            return this;
        }

        public final void setInstanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
        }

        public ActiveInstance build() {
            return new ActiveInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActiveInstance> {
        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder spotInstanceRequestId(String var1);

        public Builder instanceHealth(String var1);

        public Builder instanceHealth(InstanceHealthStatus var1);
    }
}

