/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;
import software.amazon.awssdk.util.StringUtils;

public class ReplaceRouteTableAssociationRequestMarshaller
implements Marshaller<Request<ReplaceRouteTableAssociationRequest>, ReplaceRouteTableAssociationRequest> {
    public Request<ReplaceRouteTableAssociationRequest> marshall(ReplaceRouteTableAssociationRequest replaceRouteTableAssociationRequest) {
        if (replaceRouteTableAssociationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceRouteTableAssociationRequest, "EC2Client");
        request.addParameter("Action", "ReplaceRouteTableAssociation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceRouteTableAssociationRequest.associationId() != null) {
            request.addParameter("AssociationId", StringUtils.fromString((String)replaceRouteTableAssociationRequest.associationId()));
        }
        if (replaceRouteTableAssociationRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)replaceRouteTableAssociationRequest.routeTableId()));
        }
        return request;
    }
}

