/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;
import software.amazon.awssdk.util.StringUtils;

public class ReplaceIamInstanceProfileAssociationRequestMarshaller
implements Marshaller<Request<ReplaceIamInstanceProfileAssociationRequest>, ReplaceIamInstanceProfileAssociationRequest> {
    public Request<ReplaceIamInstanceProfileAssociationRequest> marshall(ReplaceIamInstanceProfileAssociationRequest replaceIamInstanceProfileAssociationRequest) {
        if (replaceIamInstanceProfileAssociationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceIamInstanceProfileAssociationRequest, "EC2Client");
        request.addParameter("Action", "ReplaceIamInstanceProfileAssociation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        IamInstanceProfileSpecification iamInstanceProfile = replaceIamInstanceProfileAssociationRequest.iamInstanceProfile();
        if (iamInstanceProfile != null) {
            if (iamInstanceProfile.arn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.arn()));
            }
            if (iamInstanceProfile.name() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.name()));
            }
        }
        if (replaceIamInstanceProfileAssociationRequest.associationId() != null) {
            request.addParameter("AssociationId", StringUtils.fromString((String)replaceIamInstanceProfileAssociationRequest.associationId()));
        }
        return request;
    }
}

