/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.NetworkAclEntry;
import software.amazon.awssdk.services.ec2.transform.IcmpTypeCodeUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.PortRangeUnmarshaller;

public class NetworkAclEntryUnmarshaller
implements Unmarshaller<NetworkAclEntry, StaxUnmarshallerContext> {
    private static final NetworkAclEntryUnmarshaller INSTANCE = new NetworkAclEntryUnmarshaller();

    public NetworkAclEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NetworkAclEntry.Builder networkAclEntry = NetworkAclEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("cidrBlock", targetDepth)) {
                    networkAclEntry.cidrBlock(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("egress", targetDepth)) {
                    networkAclEntry.egress(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("icmpTypeCode", targetDepth)) {
                    networkAclEntry.icmpTypeCode(IcmpTypeCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6CidrBlock", targetDepth)) {
                    networkAclEntry.ipv6CidrBlock(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("portRange", targetDepth)) {
                    networkAclEntry.portRange(PortRangeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("protocol", targetDepth)) {
                    networkAclEntry.protocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ruleAction", targetDepth)) {
                    networkAclEntry.ruleAction(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ruleNumber", targetDepth)) continue;
                networkAclEntry.ruleNumber(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NetworkAclEntry)networkAclEntry.build();
    }

    public static NetworkAclEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

