/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyVpcAttributeRequestMarshaller
implements Marshaller<Request<ModifyVpcAttributeRequest>, ModifyVpcAttributeRequest> {
    public Request<ModifyVpcAttributeRequest> marshall(ModifyVpcAttributeRequest modifyVpcAttributeRequest) {
        if (modifyVpcAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyVpcAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcAttributeRequest.enableDnsHostnames() != null) {
            request.addParameter("EnableDnsHostnames.Value", StringUtils.fromBoolean((Boolean)modifyVpcAttributeRequest.enableDnsHostnames()));
        }
        if (modifyVpcAttributeRequest.enableDnsSupport() != null) {
            request.addParameter("EnableDnsSupport.Value", StringUtils.fromBoolean((Boolean)modifyVpcAttributeRequest.enableDnsSupport()));
        }
        if (modifyVpcAttributeRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)modifyVpcAttributeRequest.vpcId()));
        }
        return request;
    }
}

