/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyIdFormatRequestMarshaller
implements Marshaller<Request<ModifyIdFormatRequest>, ModifyIdFormatRequest> {
    public Request<ModifyIdFormatRequest> marshall(ModifyIdFormatRequest modifyIdFormatRequest) {
        if (modifyIdFormatRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyIdFormatRequest, "EC2Client");
        request.addParameter("Action", "ModifyIdFormat");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIdFormatRequest.resource() != null) {
            request.addParameter("Resource", StringUtils.fromString((String)modifyIdFormatRequest.resource()));
        }
        if (modifyIdFormatRequest.useLongIds() != null) {
            request.addParameter("UseLongIds", StringUtils.fromBoolean((Boolean)modifyIdFormatRequest.useLongIds()));
        }
        return request;
    }
}

