/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainer;
import software.amazon.awssdk.services.ec2.model.ImportImageRequest;
import software.amazon.awssdk.services.ec2.model.UserBucket;
import software.amazon.awssdk.util.StringUtils;

public class ImportImageRequestMarshaller
implements Marshaller<Request<ImportImageRequest>, ImportImageRequest> {
    public Request<ImportImageRequest> marshall(ImportImageRequest importImageRequest) {
        List<ImageDiskContainer> importImageRequestDiskContainersList;
        ClientData clientData;
        if (importImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importImageRequest, "EC2Client");
        request.addParameter("Action", "ImportImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importImageRequest.architecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString((String)importImageRequest.architecture()));
        }
        if ((clientData = importImageRequest.clientData()) != null) {
            if (clientData.comment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString((String)clientData.comment()));
            }
            if (clientData.uploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromInstant((Instant)clientData.uploadEnd()));
            }
            if (clientData.uploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble((Double)clientData.uploadSize()));
            }
            if (clientData.uploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromInstant((Instant)clientData.uploadStart()));
            }
        }
        if (importImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)importImageRequest.clientToken()));
        }
        if (importImageRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importImageRequest.description()));
        }
        if ((importImageRequestDiskContainersList = importImageRequest.diskContainers()) != null) {
            int diskContainersListIndex = 1;
            for (ImageDiskContainer importImageRequestDiskContainersListValue : importImageRequestDiskContainersList) {
                UserBucket userBucket;
                if (importImageRequestDiskContainersListValue.description() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Description", StringUtils.fromString((String)importImageRequestDiskContainersListValue.description()));
                }
                if (importImageRequestDiskContainersListValue.deviceName() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".DeviceName", StringUtils.fromString((String)importImageRequestDiskContainersListValue.deviceName()));
                }
                if (importImageRequestDiskContainersListValue.format() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Format", StringUtils.fromString((String)importImageRequestDiskContainersListValue.format()));
                }
                if (importImageRequestDiskContainersListValue.snapshotId() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".SnapshotId", StringUtils.fromString((String)importImageRequestDiskContainersListValue.snapshotId()));
                }
                if (importImageRequestDiskContainersListValue.url() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Url", StringUtils.fromString((String)importImageRequestDiskContainersListValue.url()));
                }
                if ((userBucket = importImageRequestDiskContainersListValue.userBucket()) != null) {
                    if (userBucket.s3Bucket() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Bucket", StringUtils.fromString((String)userBucket.s3Bucket()));
                    }
                    if (userBucket.s3Key() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Key", StringUtils.fromString((String)userBucket.s3Key()));
                    }
                }
                ++diskContainersListIndex;
            }
        }
        if (importImageRequest.hypervisor() != null) {
            request.addParameter("Hypervisor", StringUtils.fromString((String)importImageRequest.hypervisor()));
        }
        if (importImageRequest.licenseType() != null) {
            request.addParameter("LicenseType", StringUtils.fromString((String)importImageRequest.licenseType()));
        }
        if (importImageRequest.platform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importImageRequest.platform()));
        }
        if (importImageRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)importImageRequest.roleName()));
        }
        return request;
    }
}

