/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;
import software.amazon.awssdk.util.StringUtils;

public class DetachInternetGatewayRequestMarshaller
implements Marshaller<Request<DetachInternetGatewayRequest>, DetachInternetGatewayRequest> {
    public Request<DetachInternetGatewayRequest> marshall(DetachInternetGatewayRequest detachInternetGatewayRequest) {
        if (detachInternetGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachInternetGatewayRequest, "EC2Client");
        request.addParameter("Action", "DetachInternetGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachInternetGatewayRequest.internetGatewayId() != null) {
            request.addParameter("InternetGatewayId", StringUtils.fromString((String)detachInternetGatewayRequest.internetGatewayId()));
        }
        if (detachInternetGatewayRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)detachInternetGatewayRequest.vpcId()));
        }
        return request;
    }
}

