/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeImageAttributeRequestMarshaller
implements Marshaller<Request<DescribeImageAttributeRequest>, DescribeImageAttributeRequest> {
    public Request<DescribeImageAttributeRequest> marshall(DescribeImageAttributeRequest describeImageAttributeRequest) {
        if (describeImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeImageAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeImageAttributeRequest.attribute()));
        }
        if (describeImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)describeImageAttributeRequest.imageId()));
        }
        return request;
    }
}

