/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeHostReservationsRequestMarshaller
implements Marshaller<Request<DescribeHostReservationsRequest>, DescribeHostReservationsRequest> {
    public Request<DescribeHostReservationsRequest> marshall(DescribeHostReservationsRequest describeHostReservationsRequest) {
        List<String> describeHostReservationsRequestHostReservationIdSetList;
        if (describeHostReservationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHostReservationsRequest, "EC2Client");
        request.addParameter("Action", "DescribeHostReservations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeHostReservationsRequestFilterList = describeHostReservationsRequest.filter();
        if (describeHostReservationsRequestFilterList != null) {
            int filterListIndex = 1;
            for (Filter describeHostReservationsRequestFilterListValue : describeHostReservationsRequestFilterList) {
                List<String> filterValuesList;
                if (describeHostReservationsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeHostReservationsRequestFilterListValue.name()));
                }
                if ((filterValuesList = describeHostReservationsRequestFilterListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if ((describeHostReservationsRequestHostReservationIdSetList = describeHostReservationsRequest.hostReservationIdSet()) != null) {
            int hostReservationIdSetListIndex = 1;
            for (String describeHostReservationsRequestHostReservationIdSetListValue : describeHostReservationsRequestHostReservationIdSetList) {
                if (describeHostReservationsRequestHostReservationIdSetListValue != null) {
                    request.addParameter("HostReservationIdSet." + hostReservationIdSetListIndex, StringUtils.fromString((String)describeHostReservationsRequestHostReservationIdSetListValue));
                }
                ++hostReservationIdSetListIndex;
            }
        }
        if (describeHostReservationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeHostReservationsRequest.maxResults()));
        }
        if (describeHostReservationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeHostReservationsRequest.nextToken()));
        }
        return request;
    }
}

