/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAddressesRequestMarshaller
implements Marshaller<Request<DescribeAddressesRequest>, DescribeAddressesRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeAddressesRequest> marshall(DescribeAddressesRequest describeAddressesRequest) {
        List<String> describeAddressesRequestAllocationIdsList;
        List<String> describeAddressesRequestPublicIpsList;
        if (describeAddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAddressesRequest, "EC2Client");
        request.addParameter("Action", "DescribeAddresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeAddressesRequestFiltersList = describeAddressesRequest.filters();
        if (describeAddressesRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter filter : describeAddressesRequestFiltersList) {
                List<String> filterValuesList;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filter.name()));
                }
                if ((filterValuesList = filter.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeAddressesRequestPublicIpsList = describeAddressesRequest.publicIps()) != null) {
            int publicIpsListIndex = 1;
            for (String describeAddressesRequestPublicIpsListValue : describeAddressesRequestPublicIpsList) {
                if (describeAddressesRequestPublicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString((String)describeAddressesRequestPublicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        if ((describeAddressesRequestAllocationIdsList = describeAddressesRequest.allocationIds()) != null) {
            boolean bl = true;
            for (String describeAddressesRequestAllocationIdsListValue : describeAddressesRequestAllocationIdsList) {
                void var6_12;
                if (describeAddressesRequestAllocationIdsListValue != null) {
                    request.addParameter("AllocationId." + (int)var6_12, StringUtils.fromString((String)describeAddressesRequestAllocationIdsListValue));
                }
                ++var6_12;
            }
        }
        return request;
    }
}

