/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateVpnGatewayRequestMarshaller
implements Marshaller<Request<CreateVpnGatewayRequest>, CreateVpnGatewayRequest> {
    public Request<CreateVpnGatewayRequest> marshall(CreateVpnGatewayRequest createVpnGatewayRequest) {
        if (createVpnGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpnGatewayRequest, "EC2Client");
        request.addParameter("Action", "CreateVpnGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnGatewayRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createVpnGatewayRequest.availabilityZone()));
        }
        if (createVpnGatewayRequest.type() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createVpnGatewayRequest.type()));
        }
        return request;
    }
}

