/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.StorageLocation;
import software.amazon.awssdk.util.StringUtils;

public class CreateFpgaImageRequestMarshaller
implements Marshaller<Request<CreateFpgaImageRequest>, CreateFpgaImageRequest> {
    public Request<CreateFpgaImageRequest> marshall(CreateFpgaImageRequest createFpgaImageRequest) {
        StorageLocation logsStorageLocation;
        if (createFpgaImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFpgaImageRequest, "EC2Client");
        request.addParameter("Action", "CreateFpgaImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        StorageLocation inputStorageLocation = createFpgaImageRequest.inputStorageLocation();
        if (inputStorageLocation != null) {
            if (inputStorageLocation.bucket() != null) {
                request.addParameter("InputStorageLocation.Bucket", StringUtils.fromString((String)inputStorageLocation.bucket()));
            }
            if (inputStorageLocation.key() != null) {
                request.addParameter("InputStorageLocation.Key", StringUtils.fromString((String)inputStorageLocation.key()));
            }
        }
        if ((logsStorageLocation = createFpgaImageRequest.logsStorageLocation()) != null) {
            if (logsStorageLocation.bucket() != null) {
                request.addParameter("LogsStorageLocation.Bucket", StringUtils.fromString((String)logsStorageLocation.bucket()));
            }
            if (logsStorageLocation.key() != null) {
                request.addParameter("LogsStorageLocation.Key", StringUtils.fromString((String)logsStorageLocation.key()));
            }
        }
        if (createFpgaImageRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createFpgaImageRequest.description()));
        }
        if (createFpgaImageRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createFpgaImageRequest.name()));
        }
        if (createFpgaImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createFpgaImageRequest.clientToken()));
        }
        return request;
    }
}

