/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.util.StringUtils;

public class AuthorizeSecurityGroupEgressRequestMarshaller
implements Marshaller<Request<AuthorizeSecurityGroupEgressRequest>, AuthorizeSecurityGroupEgressRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<AuthorizeSecurityGroupEgressRequest> marshall(AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) {
        List<IpPermission> authorizeSecurityGroupEgressRequestIpPermissionsList;
        if (authorizeSecurityGroupEgressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeSecurityGroupEgressRequest, "EC2Client");
        request.addParameter("Action", "AuthorizeSecurityGroupEgress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeSecurityGroupEgressRequest.groupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.groupId()));
        }
        if ((authorizeSecurityGroupEgressRequestIpPermissionsList = authorizeSecurityGroupEgressRequest.ipPermissions()) != null) {
            int ipPermissionsListIndex = 1;
            for (IpPermission authorizeSecurityGroupEgressRequestIpPermissionsListValue : authorizeSecurityGroupEgressRequestIpPermissionsList) {
                List<IpRange> list;
                List<UserIdGroupPair> ipPermissionUserIdGroupPairsList;
                List<PrefixListId> ipPermissionPrefixListIdsList;
                List<Ipv6Range> ipPermissionIpv6RangesList;
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.fromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupEgressRequestIpPermissionsListValue.fromPort()));
                }
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.ipProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)authorizeSecurityGroupEgressRequestIpPermissionsListValue.ipProtocol()));
                }
                if ((ipPermissionIpv6RangesList = authorizeSecurityGroupEgressRequestIpPermissionsListValue.ipv6Ranges()) != null) {
                    int ipv6RangesListIndex = 1;
                    for (Ipv6Range ipv6Range : ipPermissionIpv6RangesList) {
                        if (ipv6Range.cidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".CidrIpv6", StringUtils.fromString((String)ipv6Range.cidrIpv6()));
                        }
                        ++ipv6RangesListIndex;
                    }
                }
                if ((ipPermissionPrefixListIdsList = authorizeSecurityGroupEgressRequestIpPermissionsListValue.prefixListIds()) != null) {
                    int prefixListIdsListIndex = 1;
                    for (Object ipPermissionPrefixListIdsListValue : ipPermissionPrefixListIdsList) {
                        if (((PrefixListId)ipPermissionPrefixListIdsListValue).prefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)((PrefixListId)ipPermissionPrefixListIdsListValue).prefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.toPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupEgressRequestIpPermissionsListValue.toPort()));
                }
                if ((ipPermissionUserIdGroupPairsList = authorizeSecurityGroupEgressRequestIpPermissionsListValue.userIdGroupPairs()) != null) {
                    Object ipPermissionPrefixListIdsListValue;
                    boolean bl = true;
                    ipPermissionPrefixListIdsListValue = ipPermissionUserIdGroupPairsList.iterator();
                    while (ipPermissionPrefixListIdsListValue.hasNext()) {
                        void var10_18;
                        UserIdGroupPair ipPermissionUserIdGroupPairsListValue = (UserIdGroupPair)ipPermissionPrefixListIdsListValue.next();
                        if (ipPermissionUserIdGroupPairsListValue.groupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".GroupId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.groupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".GroupName", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupName()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.peeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".PeeringStatus", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.peeringStatus()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.userId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".UserId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.userId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".VpcId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".VpcPeeringConnectionId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId()));
                        }
                        ++var10_18;
                    }
                }
                if ((list = authorizeSecurityGroupEgressRequestIpPermissionsListValue.ipv4Ranges()) != null) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : list) {
                        if (ipPermissionIpv4RangesListValue.cidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringUtils.fromString((String)ipPermissionIpv4RangesListValue.cidrIp()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        if (authorizeSecurityGroupEgressRequest.cidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.cidrIp()));
        }
        if (authorizeSecurityGroupEgressRequest.fromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupEgressRequest.fromPort()));
        }
        if (authorizeSecurityGroupEgressRequest.ipProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.ipProtocol()));
        }
        if (authorizeSecurityGroupEgressRequest.toPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupEgressRequest.toPort()));
        }
        if (authorizeSecurityGroupEgressRequest.sourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.sourceSecurityGroupName()));
        }
        if (authorizeSecurityGroupEgressRequest.sourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.sourceSecurityGroupOwnerId()));
        }
        return request;
    }
}

